/***************************************************************************
 *
 * Copyright (C) 2001 International Business Machines
 * All rights reserved.
 *
 * This file is part of the GPFS mmfslinux kernel module.
 *
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions 
 * are met:
 *
 *  1. Redistributions of source code must retain the above copyright notice, 
 *     this list of conditions and the following disclaimer. 
 *  2. Redistributions in binary form must reproduce the above copyright 
 *     notice, this list of conditions and the following disclaimer in the
 *     documentation and/or other materials provided with the distribution. 
 *  3. The name of the author may not be used to endorse or promote products 
 *     derived from this software without specific prior written
 *     permission. 
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES 
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; 
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *************************************************************************** */
/*
 * $Id: linux2gpfs.h,v 1.41 2001/09/22 20:08:05 dcraft Exp $
 *
 * $Log: linux2gpfs.h,v $
 * Revision 1.41  2001/09/22 20:08:05  dcraft
 * Remove kiobufs from cxiKernelIODescriptor_t.  Use temporary
 * kiobufs for map/unmap.   Remove dead code and dead comments
 * in portability layer and update readmes and license.
 * Fix traceback to appear in mmfs.log file.
 *
 * Revision 1.40  2001/08/09 21:11:21  dcraft
 * Modifications to allow running on latest Redhat 7.1 update
 * Kernel version 2.4.3-12.
 * Requires checkout of new site.mcr.proto
 *
 * Revision 1.39  2001/08/04 00:42:27  tee
 * Remove LINUX_MMAP ifdefs
 *
 * Revision 1.38  2001/07/19 23:25:01  dcraft
 * Modified linux trace to allow non blocking trace record
 * writes (format is TRACE?N).  New gpfs swapd process created
 * which is responsible for reclaiming inodes (5 percent every
 * time it runs).  Marked all our inodes so that they would be
 * ignored by linux kswapd.  Added "unused" inode to inode
 * cache that could be used as a signal that linux kswapd is
 * running and kick off gpfs swapd.  Added means to ignore attempts
 * to kill mmfsd by kswapd if the system gets low on memory.
 * All done in an attempt to avoid kswapd premature wakeup on simple
 * locks and mutexes.
 *
 * Revision 1.37  2001/05/25 14:48:21  gjertsen
 * Minor fixes to get IA64 code to compile again.
 *
 * Revision 1.36  2001/05/16 20:17:27  eshel
 * Define lookup operation only for directory files. LINUX determines if a file
 * is a directory or not base on the availability of this lookup operation in
 * the struct inode_operations.
 *
 * Revision 1.35  2001/05/12 18:38:27  schmuck
 * Fix problem with NFS returning spurious errors under load.
 *
 * Revision 1.34  2001/05/08 13:40:37  dixonbp
 * kxRegisterCleanup for linux and gpfs_f_cleanup/gpfsCleanup
 * to do the equivalent of what fopClose does on aix.
 *
 * Revision 1.33  2001/05/04 23:30:12  schmuck
 * Move "extern struct xxx_operations ..." declarations into .h file
 * instead of replicating them in various .c files.
 * Replace empty gpfs_dops_valid table with a NULL pointer.
 *
 * Revision 1.32  2001/05/04 14:49:17  wyllie
 * Remove gpfs_d_iput, since it only did an iput enclosed in traces.  As of
 * Linux kernel version 2.4.2, gpfs_d_iput should have done an iput_free()
 * anyway.
 *
 * Revision 1.31  2001/05/02 00:21:24  schmuck
 * Fix another problem found by tortureDir test on Linux:
 * On lookup and create, instantiate the dcache entry while holding the
 * inode lock, or, in case of a negative dcache entry, the directory lock.
 * This closes a window where a token revoke could clear the
 * CO_VFS_REFERENCE flag without invalidating the dcache entry.
 * It also eliminates the need for a d_revalidate operation.
 *
 * Revision 1.30  2001/04/23 21:09:40  radhak
 * Defect 337635:
 * When deleting an inode, the cxiFreeOSNode() is setting
 * inode->i_mapping->a_ops pointer to NULL causing segmentation in
 * truncate_list_inode_pages() while cleaning mmaped pages.
 *
 * Revision 1.29  2001/04/11 21:04:59  schmuck
 * Remove gpfs_s_put_inode (this only called gpfsRele, and since put_inode is
 * always called while i_count is still non-zero, gpfsRele doesn't do anything).
 * Define TraceBKL to be a no-op when compiling without VERBOSETRACE.
 *
 * Revision 1.28  2001/04/04 21:14:43  dcraft
 * Invalidate inode attributes (particularly i_nlink) when getVattr() can no longer
 * find inode.   Update attributes after rename over an existing file, so d_move
 * will correctly kill target dentry.   Add printing of dentries when "mmfsadm dump vnodes"
 * is executed.  Initial implementation of gpfs_d_revalidate.
 *
 * Revision 1.27  2001/03/29 16:42:08  dixonbp
 * Preparations for converting files from .C to .c
 *
 * Revision 1.26  2001/03/26 18:29:59  dcraft
 * Update inode attributes in OS node layer via callback to cxiSetOSNode
 * (previous setInode).  The attributes are now updated during kSFSGetattr()
 * while the lock is held to ensure validity.
 *
 * Revision 1.25  2001/03/13 21:42:19  radhak
 * Defect 332458,333008:
 * need to register vm_ops->open function for incrementing mmap reference
 * count for every child process forked after mmap.
 *
 * Revision 1.24  2001/01/19 20:55:14  radhak
 * LINUX_MMAP: linux 2.4.0 kernel rework.
 * For time being disabled single node mmap symantics because of lack of
 * interface to invalidate memory mapped pages
 *
 * Revision 1.23  2001/01/12 21:11:06  eshel
 * add prototype for setInode()
 *
 * Revision 1.22  2000/12/29 22:22:33  radhak
 * Defect 322452: Before calling gpfs_filemap_sync get lock.
 * Also added some traces.
 *
 * Revision 1.21  2000/12/19 21:11:57  wyllie
 * Remove assertions and traces about the state of the Linux BKL.  Linux does
 * not keep track of who owns the lock, so these asserts were blowing up on
 * an SMP if the kernel lock happened to be held by the other processor.
 *
 * Revision 1.20  2000/12/18 13:53:17  gjertsen
 * More cleanup of comments/documentation.
 *
 * Revision 1.19  2000/12/15 13:56:44  gjertsen
 * Clean up documentation.
 *
 * Revision 1.18  2000/12/04 17:49:55  wyllie
 * Do not allow 'read' of a directory, only 'readdir'.  Otherwise the prefetch
 * code could build a buffer descriptor for a hole in a directory, and the read
 * would populate the buffer with binary zeros.  A later fast lookup would find
 * a directory block with an invalid format and barf.
 *
 * Revision 1.17  2000/11/08 01:10:20  radhak
 * More linux mmap code
 *
 * Revision 1.16  2000/11/06 19:56:15  gjertsen
 * Linux code cleanup and put in build safeguards.
 *
 * Revision 1.15  2000/11/03 20:27:01  dcraft
 * Build SMP, UP, NOHIGHMEM, and 4G memory variations of mmfslinux in
 * one pass.   Names are mmfslinux_UP1G, mmfslinux_UP4G, mmfslinux_SMP1G,
 * mmfslinux_SMP4G.
 *
 * Revision 1.14  2000/11/02 19:46:26  gjertsen
 * Linux code split. Pull out NBD stuff.
 *
 *
 */
#ifndef _h_linux2gpfs
#define _h_linux2gpfs

#include <cxiTypes.h>
#include <Logger-gpl.h>

#ifdef __cplusplus
#include <prelinux.h>
#endif

#include <linux/kdev_t.h>
#include <linux/fs.h>

#ifdef __cplusplus
#include <postlinux.h>
#endif
#include <cxiSystem.h>

#ifdef NTRACE
#define PRINTINODE(i)  ((void)0)
#define PRINTDENTRY(d) ((void)0)
#define PRINTSBLOCK(s) ((void)0)
#define PRINTFILE(f)   ((void)0)
#else
#define PRINTINODE(i)  printInode(i)
#define PRINTDENTRY(d) printDentry(d)
#define PRINTSBLOCK(s) printSblock(s)
#define PRINTFILE(f)   printFile(f)
#endif

/* forward declarations */
struct ext_cred_t;
struct dentry;
struct super_block;
struct file;
struct nameidata;
struct page;
struct iattr;
struct inode;
struct vm_area_struct;

/* inode.C */
#ifdef __cplusplus
extern "C"
{
#endif
  void setCred(struct ext_cred_t *);
  int gpfs_i_create(struct inode *, struct dentry *, int);
  struct dentry *gpfs_i_lookup(struct inode *, struct dentry *);
  int gpfs_i_link(struct dentry *, struct inode *, struct dentry *);
  int gpfs_i_unlink(struct inode *, struct dentry *);
  int gpfs_i_symlink(struct inode *, struct dentry *, const char *);
  int gpfs_i_mkdir(struct inode *, struct dentry *, int);
  int gpfs_i_rmdir(struct inode *, struct dentry *);
  int gpfs_i_mknod(struct inode *, struct dentry *, int, int);
  int gpfs_i_rename(struct inode *, struct dentry *, struct inode *,
                    struct dentry *);
  int gpfs_i_readlink(struct dentry *, char *, int);
  int gpfs_i_follow_link(struct dentry *,  struct nameidata *);
  int gpfs_i_readpage(struct file *, struct page *);
# if LINUX_KERNEL_VERSION >= 2040000
  int gpfs_i_writepage(struct page *);
# else
  int gpfs_i_writepage(struct file *, struct page *);
# endif
  int gpfs_i_bmap(struct inode *, int);
  void gpfs_i_truncate(struct inode *);
  int gpfs_i_permission(struct inode *, int);
  int gpfs_i_smap(struct inode *, int);
  int gpfs_i_updatepage(struct file *, struct page *, const char *,
                        unsigned long, uint, int);
  int gpfs_i_revalidate(struct dentry *);
  int gpfs_i_setattr(struct dentry *, struct iattr *);
  int gpfs_i_getattr(struct dentry *, struct iattr *);
  void gpfs_i_truncatepage(struct page *);
#ifdef __cplusplus
}
#endif

#ifdef __cplusplus
extern "C"
{
#endif
int gpfs_i_getattr_internal(struct inode *iP);
int gpfs_i_setattr_internal(struct inode *iP, struct iattr *aP);
void printInode(struct inode *);
void printDentry(struct dentry *);
#ifdef __cplusplus
}
#endif

/* file.C */
#ifdef __cplusplus
extern "C"
{
#endif
  loff_t gpfs_f_llseek(struct file *, loff_t, int);
  ssize_t gpfs_f_read(struct file *, char *, size_t, loff_t *);
  ssize_t gpfs_f_dir_read(struct file *, char *, size_t, loff_t *);
  ssize_t gpfs_f_write(struct file *, const char *, size_t, loff_t *);
  int gpfs_f_readdir(struct file *, void *, filldir_t);
  uint gpfs_f_poll(struct file *, struct poll_table_struct *);
  int gpfs_f_ioctl(struct inode *, struct file *, uint, unsigned long);
  int gpfs_f_mmap(struct file *, struct vm_area_struct *);
  int gpfs_f_open(struct inode *, struct file *);
  int gpfs_f_release(struct inode *, struct file *);
  int gpfs_f_fsync(struct file *, struct dentry *, int datasync);
  int gpfs_f_fasync(int, struct file *, int);
  int gpfs_f_check_media_change(kdev_t);
  int gpfs_f_revalidate(kdev_t);
  int gpfs_f_lock(struct file *, int, struct file_lock *);
  ssize_t gpfs_f_readv(struct file *, const struct iovec *, unsigned long, 
                   loff_t *);
  int gpfs_f_writev(struct file *, const struct iovec *, unsigned long, 
                    loff_t *);
  int gpfs_f_cleanup(struct inode *iP, struct file *fP);
  struct page *gpfs_filemap_nopage(struct vm_area_struct * area,
                                 unsigned long address, int no_share);
  void gpfs_filemap_close(struct vm_area_struct * area);
  void gpfs_filemap_open(struct vm_area_struct * area);

#ifdef __cplusplus
}
#endif

/* super.C */
#ifdef __cplusplus
extern "C"
{
#endif
#ifdef VERBOSETRACE
  void TraceBKL();
#else
#define TraceBKL() ((void)0)
#endif
  void gpfs_s_read_inode(struct inode *);
  void gpfs_s_read_inode2(struct inode *, void *);
  void gpfs_s_delete_inode(struct inode *);
  int gpfs_s_notify_change(struct dentry *, struct iattr *);
  void gpfs_s_put_super(struct super_block *);
  int gpfs_s_statfs(struct super_block *, struct statfs *);
  void gpfs_s_umount_begin(struct super_block *);
  int gpfs_s_remount(struct super_block *, int *, char *);
  void gpfs_s_write_inode(struct inode *);
  void gpfs_s_clear_inode(struct inode *);
  void gpfs_s_write_super(struct super_block *);
  struct super_block *gpfs_read_super(struct super_block *, void *, int);
  int mmfsd_release(struct inode *, struct file *);
  int exec_mmfs(void *);
  void kill_mmfsd(void);
  void gpfs_unreg_fs();
  int gpfs_reg_fs();
  int fork_mmfsd();
  int fork_mount_helper(char *data);
  void swapd_s_clear_inode(struct inode *);
  void swapd_s_read_inode(struct inode *);
#ifdef __cplusplus
}
#endif

/* Find gpfs info from a linux inode. */
#define VP_TO_CNP(VP)           ((struct cxiNode_t *)((VP)->u.generic_ip))
#define VP_TO_GNP(VP)           ((gpfsNode_t *)((VP)->u.generic_ip))
#define VP_TO_PVP(VP)           ((struct gpfsVfsData_t *)((VP)->i_sb->u.generic_sbp))
#define GNP_TO_VP(GNP)          ((struct inode *)((GNP)->osNodeP))
#define VP_TO_NFSP(VP)          ((VP_TO_CNP((struct inode *)(VP))->nfsP))

/* block.C */
#ifdef __cplusplus
extern "C"
{
#endif
  int gpfs_b_open(struct inode *inode, struct file *file);
  int gpfs_b_release(struct inode *inode, struct file *file);
  int gpfs_b_ioctl(struct inode *inode, struct file *file, unsigned p1,
                   unsigned long p2);
  int gpfs_b_check_media_change(kdev_t dev);
  int gpfs_b_revalidate(kdev_t dev);
  int gpfs_block_init();
  void gpfs_block_clean();

  int gpfs_fb_open(struct inode *inode, struct file *file);
  int gpfs_fb_release(struct inode *inode, struct file *file);
  int gpfs_fb_ioctl(struct inode *inode, struct file *file, unsigned p1,
                    unsigned long p2);
  ssize_t gpfs_fb_read(struct file *file, char *buf, size_t nbytes, 
                       loff_t *ppos);
  ssize_t gpfs_fb_write(struct file *file, const char *buf, size_t nbytes,
                        loff_t *ppos);
#ifdef __cplusplus
}
#endif

/* dir.C */
#ifdef __cplusplus
extern "C"
{
#endif
  int gpfs_d_invalid(struct dentry *dentry, int flags);
#ifdef __cplusplus
}
#endif

/* gpfs operations tables */
extern struct super_operations  gpfs_sops;
extern struct super_operations  swapd_sops;
#define gpfs_dops_valid (*(struct dentry_operations*)0)  /* no ops defined */
extern struct dentry_operations gpfs_dops_ddeletepending;
extern struct dentry_operations gpfs_dops_invalid;
extern struct file_operations gpfs_fops;
extern struct file_operations gpfs_dir_fops;
extern struct file_operations gpfs_fbps;
extern struct file_operations gpfs_cleanup_fops;
extern struct inode_operations  gpfs_iops_stdperm;
extern struct inode_operations  gpfs_iops_xperm;
extern struct inode_operations  gpfs_dir_iops_stdperm;
extern struct inode_operations  gpfs_dir_iops_xperm;
extern struct inode_operations  gpfs_link_iops;
extern struct block_device_operations gpfs_bops;
extern struct address_space_operations gpfs_aops;
extern struct address_space_operations gpfs_aops_after_inode_delete;
extern struct vm_operations_struct gpfs_vmop;

#endif /* _h_linux2gpfs */
